<?php
/**
 * Kolo functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Kolo
 */

if ( ! function_exists( 'kolo_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function kolo_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on Kolo, use a find and replace
	 * to change 'kolo' to the name of your theme in all the template files.
	 */
	load_theme_textdomain( 'kolo', get_template_directory() . '/languages' );
	
	/*
	 * Set woocommerce support  
	 * 
	 */
	add_theme_support( 'woocommerce' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'kolo_team_img', 600,600, true );
	add_image_size( 'kolo_port_img', 800,600, true );
	add_image_size( 'kolo_testi_img', 100,100, true );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'main_menu' => esc_html__( 'Main Menu', 'kolo' ),
		'footer_menu' => esc_html__( 'Footer Menu', 'kolo' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	add_theme_support( 'post-formats', array(
		'audio',
		'video',
	) );
	
	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'kolo_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );
	add_editor_style( array( 'css/editor-style.css', kolo_fonts_url() ) );	
}
endif;
add_action( 'after_setup_theme', 'kolo_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function kolo_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'kolo_content_width', 640 );
}
add_action( 'after_setup_theme', 'kolo_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function kolo_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'kolo' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'kolo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );	
	
	register_sidebar( array(
		'name'          => esc_html__( 'Shop Sidebar', 'kolo' ),
		'id'            => 'sidebar-2',
		'description'   => esc_html__( 'Add widgets here.', 'kolo' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'kolo_widgets_init' );

function kolo_main_menu() {
		wp_nav_menu( array(
		'theme_location'    => 'main_menu',
		'depth'             => 5,
		'container'         => false,
		'menu_class'        => 'nav navbar-nav navbar-right',
		'fallback_cb'       => 'kolo_navwalker::fallback',
		
		)
	); 	
}

function kolo_footer_menu() {
		wp_nav_menu( array(
		'theme_location'    => 'footer_menu',
		'depth'             => 5,
		'container'         => false,
		'menu_class'        => 'contact-socials clearfix',
		'fallback_cb'       => 'kolo_navwalker::fallback',
		
		)
	); 	
}

/**
 * register google fonts
 */
function kolo_fonts_url() {
	$fonts_url = '';
	
	/* Translators: If there are characters in your language that are not
	* supported by Source Sans Pro, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$lato = _x( 'on', 'Lato font: on or off', 'kolo' );
	
	if ( 'off' !== $lato ) {
	$font_families = array();
	 
	if ( 'off' !== $lato ) {
	$font_families[] = 'Lato:400,100,100italic,300,300italic,400italic,700,700italic,900,900italic';
	}
	 
	 
	$query_args = array(
	'family' => urlencode( implode( '|', $font_families ) ),
	'subset' => urlencode( 'latin,latin-ext' ),
	);

	$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
	}
	 
	return esc_url_raw( $fonts_url );	
}

/**
 * Enqueue scripts and styles.
 */
function kolo_scripts() {
	
	// Add Google Fonts css
	wp_enqueue_style( 'google-fonts', kolo_fonts_url(), array(), null );
	
	wp_enqueue_style('bootstrap' , get_template_directory_uri(). '/css/bootstrap.css');
	wp_enqueue_style('font-awesome.min' , get_template_directory_uri(). '/css/font-awesome.min.css');
	wp_enqueue_style('owl.carousel' , get_template_directory_uri(). '/css/owl.carousel.css');
	wp_enqueue_style('prettyPhoto' , get_template_directory_uri(). '/css/prettyPhoto.css');
	wp_enqueue_style('flexslider' , get_template_directory_uri(). '/css/flexslider.css');
	wp_enqueue_style('style' , get_template_directory_uri(). '/css/style.css');
	wp_enqueue_style('kolo-style', get_stylesheet_uri() );
	wp_enqueue_style('responsive' , get_template_directory_uri(). '/css/responsive.css');

	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'modernizr.custom', get_template_directory_uri() . '/js/modernizr.custom.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'jquery.easing', get_template_directory_uri() . '/js/jquery.easing.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'jquery.scrollUp', get_template_directory_uri() . '/js/jquery.scrollUp.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'owl.carousel', get_template_directory_uri() . '/js/owl.carousel.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'jquery.nav', get_template_directory_uri() . '/js/jquery.nav.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'count-to', get_template_directory_uri() . '/js/count-to.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'jquery.appear', get_template_directory_uri() . '/js/jquery.appear.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'jquery.prettyPhoto', get_template_directory_uri() . '/js/jquery.prettyPhoto.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'jquery.mixitup', get_template_directory_uri() . '/js/jquery.mixitup.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'retina', get_template_directory_uri() . '/js/retina.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'jquery.flexslider', get_template_directory_uri() . '/js/jquery.flexslider.js', array('jquery'), '1.1', true );
	wp_enqueue_script( 'custom', get_template_directory_uri() . '/js/custom.js', array('jquery'), '1.1', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'kolo_scripts' );

/*---------------------------------------------
 Initialising KingComposer shortcode editor
----------------------------------------------*/ 
if (class_exists('KingComposer')) {
 function kolo_requireKcExtend(){
  include_once( get_template_directory().'/kc_extend/extend_kc.php');  
 }
 add_action('init', 'kolo_requireKcExtend',2);
}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load PHP file.
 */
require get_template_directory() . '/inc/navwalker.php';
require get_template_directory() . '/inc/kolo_metabox.php';
require get_template_directory() . '/inc/custom-functions.php';
require get_template_directory() . '/inc/admin/kolo-options.php';
require get_template_directory() . '/inc/admin/custom_css.php';
require get_template_directory() . '/inc/plugin-activator.php';
require get_template_directory() . '/inc/required-plugin.php';
require get_template_directory() . '/inc/kolo-wc-function.php';

// modify search widget
function kolo_my_search_form( $form ) {
	$form = '
		<div class="search_form">
			<form role="search" method="get" id="searchform" class="searchform" action="' . esc_url(home_url( '/' )) . '" >
			<input type="text" value="' . esc_attr(get_search_query()) . '" name="s" id="s" class="form-control" placeholder="' . esc_attr__('Enter Keyword Here &amp; Search...' , 'kolo') .'">
			</form>
		</div>
		
        ';
	return $form;
}
add_filter( 'get_search_form', 'kolo_my_search_form' );
// comment list modify

function kolo_comments($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?>

<li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
	<div class="single_comment">
		<div class="media">
			<div class="comment_avatar">
				<?php echo get_avatar( $comment, 70 ); ?>
			</div>

			<div class="media-body text-left comment_single">			
				<h5 class="media-heading"><?php comment_author_link() ?> <span>&nbsp; &nbsp; <?php echo esc_html(get_comment_date('F j, Y')); ?> <?php echo esc_html(get_comment_date('g:i')); ?></span></h5>
				<div class="creply_link"> <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?></div>
				<?php if ($comment->comment_approved == '0') : ?>
				<p><em><?php esc_html_e('Your comment is awaiting moderation.','kolo'); ?></em></p>
				<?php endif; ?>
				 <?php comment_text(); ?>							
			</div>
		</div>
	</div>				
</li>


<?php } 

// comment box title change
add_filter( 'comment_form_defaults', 'kolo_remove_comment_form_allowed_tags' );
function kolo_remove_comment_form_allowed_tags( $defaults ) {

	$defaults['comment_notes_after'] = '';
	$defaults['comment_notes_before'] = '';
	return $defaults;

}

function kolo_comment_reform ($arg) {

$arg['title_reply'] = esc_html__('Write your comment Here','kolo');
$arg['comment_field'] = '<div class="row"><div class="form-group has-feedback col-md-12"><textarea id="comment" class="comment_field form-control" name="comment" cols="77" rows="3" placeholder="'. esc_html__("Write your Comment", "kolo").'" aria-required="true"></textarea></div></div>';


return $arg;

}
add_filter('comment_form_defaults','kolo_comment_reform');

// comment form modify

function kolo_modify_comment_form_fields($fields){
	$commenter = wp_get_current_commenter();
	$req	   = get_option( 'require_name_email' );

	$fields['author'] = '<div class="row"><div class="form-group has-feedback col-md-4"><input type="text" name="author" id="author" value="'. esc_attr( $commenter['comment_author'] ) .'" placeholder="'. esc_attr__("Your Name *", "kolo").'" size="22" tabindex="1"'. ( $req ? 'aria-required="true"' : '' ).' class="input-name form-control" /></div>';

	$fields['email'] = '<div class="form-group has-feedback col-md-4"><input type="text" name="email" id="email" value="'. esc_attr( $commenter['comment_author_email'] ) .'" placeholder="'.esc_attr__("Your Email *", "kolo").'" size="22" tabindex="2"'. ( $req ? 'aria-required="true"' : '' ).' class="input-email form-control"  /></div>';
	
	$fields['url'] = '<div class="form-group has-feedback col-md-4"><input type="text" name="url" id="url" value="'. esc_attr( $commenter['comment_author_url'] ) .'" placeholder="'. esc_attr__("Website", "kolo").'" size="22" tabindex="2"'. ( $req ? 'aria-required="false"' : '' ).' class="input-url form-control"  /></div></div>';

	return $fields;
}
add_filter('comment_form_default_fields','kolo_modify_comment_form_fields');

function kolo_wp_kses($val){
	return wp_kses($val, array(
	
	'p' => array(),
	'span' => array(),
	'div' => array(),
	'strong' => array(),
	'b' => array(),
	'br' => array(),
	'h1' => array(),
	'h2' => array(),
	'h3' => array(),
	'h4' => array(),
	'h5' => array(),
	'h6' => array(),
	'a'=> array('href' => array(),'target' => array()),
	
	), '');
}
	
