<?php


add_action( 'cmb2_init', 'kolo_page_metabox' );

function kolo_page_metabox(){
	// Start with an underscore to hide fields from custom fields list
	$prefix = '_kolo_';

	// Page Options	

	$cmb2_post_1_options = new_cmb2_box( array(
		'id'           => $prefix . 'p1banner_option',
		'title'        => esc_html__( 'Upload Banner Image', 'kolo' ),
		'object_types' => array( 'page' , 'post', 'product'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );
	
	$cmb2_post_1_options->add_field( array(
	    'id'               => $prefix .'upload_banner_image',
	    'desc'             => esc_html__( 'Please upload banner image here ','kolo' ),
		 'type'             => 'file',
	) );		
	
	//Post Options	
	$cmb2_post_options = new_cmb2_box( array(
		'id'           => $prefix . 'posts_option',
		'title'        => esc_html__( 'Post Formats', 'kolo' ),
		'object_types' => array( 'post'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );	
	
	
	$cmb2_post_options->add_field( array(
	    'name'             => esc_html__('Audio / Video Post Embed Code ' , 'kolo'),
	    'id'               => $prefix .'avid_post_title',
	    'type'    => 'title',
	) );		
	
	$cmb2_post_options->add_field( array(
	    'name'             => esc_html__('Embed Code' , 'kolo'),
	    'id'               => $prefix .'embed_code',
		'desc'    => esc_html__('enter embed code here' , 'kolo'),
	    'type'    => 'textarea_code',
	) );		
	
		
	$cmb2_team = new_cmb2_box( array(
		'id'           => $prefix . 'team_mem_options',
		'title'        => esc_html__( 'Team Member Info', 'kolo' ),
		'object_types' => array( 'k_team'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );
	
	$cmb2_team->add_field( array(
	    'name'             => esc_html__('Designation' , 'kolo'),
	    'id'               => $prefix .'team_designation',
	    'desc'             => esc_html__( 'write designation here','kolo' ),
		'type'       => 'text',
		'default'       => 'Programmer',
	) );	
	
	$cmb2_team->add_field( array(
	    'name'             => esc_html__('Decription' , 'kolo'),
	    'id'               => $prefix .'team_description',
	    'desc'             => esc_html__( 'write description here','kolo' ),
		'type'       => 'textarea',
		'default'       => 'Proin a velit accumsan convallis aliquam aliquam vitae aenean placerat porttitor vitae aenean placerat velit aliquam',
	) );	
	
	$teamgroup_field_id = $cmb2_team->add_field( array(
		'id'          => $prefix .'team_group_field_opt',
		'type'        => 'group',
		// 'repeatable'  => false, // use false if you want non-repeatable group
		'options'     => array(
			'group_title'   => esc_html__( 'Social Media link {#}', 'kolo' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'    => esc_html__( 'Add New Link', 'kolo' ),
			'remove_button' => esc_html__( 'Remove Link', 'kolo' ),
			'sortable'      => true, // beta
			// 'closed'     => true, // true to have the groups closed by default
		),
	) );

	// Id's for group's fields only need to be unique for the group. Prefix is not needed.
	$cmb2_team->add_group_field( $teamgroup_field_id, array(
		'name' => esc_html__('Social Media Icon' , 'kolo'),
		'id'   => $prefix .'team_sm_icon',
		'type' => 'text',
		'default' => 'fa-facebook',
		'description' => esc_html__('enter social media icon here. get all icon http://fortawesome.github.io/Font-Awesome/icons/' , 'kolo'),
		// 'repeatable' => true, // Repeatable fields are supported w/in repeatable groups (for most types)
	) );

	$cmb2_team->add_group_field( $teamgroup_field_id, array(
		'name' => esc_html__('Social Media Url' , 'kolo'),
		'description' => esc_html__( 'enter social media url','kolo' ),		
		'id'   => $prefix .'team_sm_link',
		'type' => 'text',
		'default' => '#',
	) );		
	
	$cmb2_team->add_group_field( $teamgroup_field_id, array(
		'name' => esc_html__('Social Media Hover Color' , 'kolo'),
		'description' => esc_html__( 'enter social media hovor color','kolo' ),		
		'id'   => $prefix .'team_sm_hovor_color',
		'type' => 'colorpicker',
		'default' => '#3b5998',
	) );	
		
	
	$cmb2_testi = new_cmb2_box( array(
		'id'           => $prefix . 'ktestimonials_options',
		'title'        => esc_html__( 'Testimonials Info', 'kolo' ),
		'object_types' => array( 'ktestimonials'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_testi->add_field( array(
	    'name'             => esc_html__('Designation' , 'kolo'),
	    'id'               => $prefix .'test_designation',
	    'desc'             => esc_html__( 'write designation here','kolo' ),
		'type'             => 'text',
		'default'    => 'Jonathan Doe',
	) );		

	$cmb2_pricing_table = new_cmb2_box( array(
		'id'           => $prefix . 'pricing_table_options',
		'title'        => esc_html__( 'Pricing Table Info', 'kolo' ),
		'object_types' => array( 'pricing_table'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Feature Plan' , 'kolo'),
	    'id'               => $prefix .'pt_featur_plan',
	    'desc'             => esc_html__( 'choice this paln as feature','kolo' ),
		'type'             => 'checkbox',
		'default'    => '0',
	) );		
	
	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Currency Type' , 'kolo'),
	    'id'               => $prefix .'pt_currency_type',
	    'desc'             => esc_html__( 'write currency type here','kolo' ),
		'type'             => 'text',
		'default'    => '$',
	) );		
	
	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Amount' , 'kolo'),
	    'id'               => $prefix .'pt_amount',
	    'desc'             => esc_html__( 'write amount here','kolo' ),
		'type'             => 'text',
		'default'    => '50',
	) );	
	
	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Amount Cent' , 'kolo'),
	    'id'               => $prefix .'pt_amoun_cent',
	    'desc'             => esc_html__( 'write amount cent here','kolo' ),
		'type'             => 'text',
		'default'    => '99',
	) );	
	
	
	$pricing_field_id = $cmb2_pricing_table->add_field( array(
		'id'          => $prefix .'pricing_group_field_opt',
		'type'        => 'group',
		// 'repeatable'  => false, // use false if you want non-repeatable group
		'options'     => array(
			'group_title'   => esc_html__( 'Pricing Feature {#}', 'kolo' ), // since version 1.1.4, {#} gets replaced by row number
			'add_button'    => esc_html__( 'Add New Feature', 'kolo' ),
			'remove_button' => esc_html__( 'Remove Feature', 'kolo' ),
			'sortable'      => true, // beta
			// 'closed'     => true, // true to have the groups closed by default
		),
	) );

	// Id's for group's fields only need to be unique for the group. Prefix is not needed.
	$cmb2_pricing_table->add_group_field( $pricing_field_id, array(
		'name' => esc_html__('Feature' ,'kolo' ),
		'id'   => $prefix .'pt_feature',
		'type' => 'textarea',
		'default' => 'Up to <strong>5 Projects</strong>',
	) );	
	
	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Button Text' , 'kolo'),
	    'id'               => $prefix .'pt_button_text',
	    'desc'             => esc_html__( 'write Button text here','kolo' ),
		'type'             => 'text',
		'default'    => 'Select Plan',
	) );		
	
	$cmb2_pricing_table->add_field( array(
	    'name'             => esc_html__('Button Link' , 'kolo'),
	    'id'               => $prefix .'pt_button_link',
	    'desc'             => esc_html__( 'write Button link here','kolo' ),
		'type'             => 'text',
		'default'    => '#',
	) );	

	$cmb2_tab = new_cmb2_box( array(
		'id'           => $prefix . 'tab_options',
		'title'        => esc_html__( ' ', 'kolo' ),
		'object_types' => array( 'k_tab', 'k_accordion'), // Post type
		'context'      => 'normal',
		'priority'     => 'high',
		'show_names'   => true, // Show field names on the left
		//'show_on'      => array( 'id' => array( 2, ) ), // Specific post IDs to display this metabox
	) );

	$cmb2_tab->add_field( array(
	    'name'             => esc_html__('Active Item' , 'kolo'),
	    'id'               => $prefix .'active_tab',
	    'desc'             => esc_html__( 'active this item','kolo' ),
		'type'             => 'checkbox',
		'default'    => '0',
	) );		
}