<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Kolo
 */

 
$kolo_port_img = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()),'kolo_port_img'); 
$categories_list = get_the_category_list( esc_html__( ', ', 'kolo' ) );
$tags_list = get_the_tag_list( '', esc_html__( ', ', 'kolo' ) );
?>

							
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if($kolo_port_img){?>	
		<!-- Post Image -->
		<div class="blog-post-img">
			<?php if(!is_single()){ ?>
				<a href="<?php the_permalink();?>"><img class="img-responsive" src="<?php echo esc_url($kolo_port_img['0']);?>" alt="" />	</a>
			<?php }else{ ?>
			<?php the_post_thumbnail('kolo_port_img', array('class' => 'img-responsive')); ?>
			<?php }?>
		</div>
	<?php }?>
	<!-- Post Titlebar -->
	<div class="blog-post-titlebar sin_title">

		<?php
			if ( is_single() ) :
				the_title( '<h4 class="entry-title">', '</h4>' );
			else :
				the_title( sprintf( '<h4 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
			endif;
		?>		
	</div>
			
	<!-- Post Meta -->
	<div class="blog-post-info sin_post_info">
		<i class="fa fa-calendar"></i> <?php echo esc_html(get_the_time('F d, Y')); esc_html_e(' - ', 'kolo');?> <i class="fa fa-comments"></i> <?php comments_popup_link( '0 comments', '1 comment', '% comments', 'comments-link', '0'); esc_html_e(' - ' , 'kolo'); if($categories_list){ ?>
		<i class="fa fa-folder-open-o"></i> <?php echo $categories_list; } if($tags_list){ esc_html_e(' - ' , 'kolo'); ?> <i class="fa fa-tags"></i> <?php echo $tags_list; }?>
	</div>
			
	<!-- Post Summary -->
	<div class="blog-post-desc sing_blog_post_desc">
		<?php if(is_single()) { the_content();
		
		}else{
			
			the_excerpt ();
		}	
	
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'kolo' ),
				'after'  => '</div>',
			) );
		?>		
	</div>
	
	<?php if(!is_single()){?>
		<!-- Post Link -->
		<div class="article_link sin_article_link">
			<a class="" href="<?php the_permalink();?>"><?php esc_html_e('Read more' , 'kolo');?></a>
		</div>
	<?php }?>
	
</article><!-- #post-## -->
